//----------------------------------------------------------------------
//
// Copyright (c) Microsoft Corporation 1998-1999
// All Rights Reserved
//
// Abstract:
//
// prndemo.js -PrnAdmin demo JavaScript
//
// Usage:
// prndemo.js [-agl?][-b printer][-c server][-i ip-adrress]");
//                   [-d driver][-p port]");
//
// Examples:
//   prndemo.js -g -i 1.2.3.4
//   prndemo.js -a -b Printer -d "Driver" -p lpt1:
//   prndemo.js -a -b Printer -d "Driver" -p 1.2.3.4
//   prndemo.js -l -c \\server
//
//---------------------------------------------------------------------

//
// Debugging trace flags, to enable debug output trace message
// change gDebugFlag to true.
//
kDebugTrace = 1;
kDebugError = 2;
gDebugFlag = false;

//
// Message to be displayed if the scripting host is not cscript
//                            
kMessage = "Please run this script using CScript.\n" +
           "This can be achieved by\n" +
           "1. Using \"CScript script.vbs arguments\" or\n" +
           "2. Changing the default Windows Scripting Host to CScript\n" +
           "   using \"CScript //H:CScript //S\" and running the script \n" +
           "   \"script.vbs arguments\".\n";

//
// Operation action values.
//
kActionUnknown = 0;
kActionAdd     = 1;
kActionGet     = 2;
kActionList    = 3;

//
// Port Types
//
kTcpRaw   = 1;
kTcpLPr   = 2;
kLocal    = 3;
kLprMon   = 5;
kHPdlc    = 7;
kUnknown  = 8;

kErrorSuccess = 0;
kErrorExists  = 52;

//
// The only supported conversion is from lpr mon to tcp
//
kLprToTcp = 1

main();

//
// Main execution start here
//
function main()
{
    var iAction
    var ParamDict = new ActiveXObject("Scripting.Dictionary");

    //
    // Abort if the host is not cscript
    //
    if (!IsHostCscript())
    {
        WScript.echo(kMessage);
        
        WScript.quit();
    }
    
    iAction = ParseCommandLine(ParamDict);

    switch(iAction)
    {
    case kActionList:
             ListPrinters(ParamDict);
             break;
                 
    case kActionGet:    
             GetEquivalent(ParamDict);
             break;

    case kActionAdd:
             AddPrinter(ParamDict);
             break;
    
    default:
             Usage(true);
    }    
}

//
// Get the TCP equivalent of a lpr mon port
//
function GetEquivalent(ParamDict)
{
    DebugPrint(kDebugTrace, "In GetEquivalent");
    
    var oMaster;
    var oPort;
    
    try {

        oMaster = new ActiveXObject("PrintMaster.PrintMaster.1");
        
        oPort   = new ActiveXObject("Port.Port.1");
    
        oPort.HostAddress = ParamDict.Item("IPAddress");
        
        oMaster.PortConversion(oPort, kLprToTcp);

        if (oPort.DeviceType != "") 
        {
            WScript.echo("DeviceType  " + oPort.DeviceType);
        }
        else
        {
            WScript.echo("The device did not respond. Default port settings will be displayed");
        }
        
        WScript.echo("Name        " + oPort.PortName);
        WScript.echo("HostAddress " + oPort.HostAddress);
        
        if (oPort.PortType == kTcpRaw)
        { 
            WScript.echo("Protocol    RAW");
            
            WScript.echo("PortNumber  " + oPort.PortNumber);
        }
        else
        {
            WScript.echo("Protocol    LPR")
        
            WScript.echo("Queue       " + oPort.QueueName);
        }
        
        WScript.echo(oPort.SNMP        ? "SNMP        Enabled" : "SNMP        Disabled");
        
        WScript.echo(oPort.DoubleSpool ? "DoubleSpool Yes"     : "DoubleSpool No");        
    }
    catch(Err)
    {
        WScript.echo("Error " + (0xFFFF & Err.number).toString() + ". " + Err.description);     
    }
}

//
// Add a printer
//
function AddPrinter(ParamDict)
{
    DebugPrint(kDebugTrace, "In AddPrinter");

    var oMaster; 
    var oPort;
    var oPrinter;
    
    try {

        oMaster  = new ActiveXObject("PrintMaster.PrintMaster.1");

        oPort    = new ActiveXObject("Port.Port.1");

        oPrinter = new ActiveXObject("Printer.Printer.1");

        //
        // Check if the user passed in a port name
        //
        if (ParamDict.Exists("Port")) 
        {
            oPrinter.PortName = ParamDict.Item("Port");
        }
        else if (ParamDict.Exists("IPAddress")) 
        {
            oPort.HostAddress = ParamDict.Item("IPAddress");
       
            oMaster.PortConversion(oPort, kLprToTcp);

            //
            // Add the TCP port
            // 
            try 
            {
                oPort.ServerName = ParamDict.Item("Server");

                oMaster.PortAdd(oPort);
            }
            catch(Err)
            {
                //
                // Check if port already exists; if it doesn't then propagate the error
                // 
                if (Err.number & 0xFFFF != kErrorExists) 
                {
                   throw Err;
                }                
            }

            oPrinter.PortName = oPort.PortName;
        }

        oPrinter.PrinterName = ParamDict.Item("Printer");
        
        oPrinter.DriverName  = ParamDict.Item("Driver");

        oPrinter.ServerName  = ParamDict.Item("Server");

        oMaster.PrinterAdd(oPrinter); 
        
        WScript.echo("Success adding printer " + oPrinter.PrinterName);
    }
    catch(Err)
    {
        WScript.echo("Error " + (0xFFFF & Err.number).toString() + ". " + Err.description);        
    }
}

//
// List Printers
//
function ListPrinters(ParamDict)
{
    var oMaster;
    var oPrinter; 
    var Enum; 

    try 
    {
        oMaster = new ActiveXObject("PrintMaster.PrintMaster.1");

        Enum    = new Enumerator(oMaster.Printers(ParamDict.Item("Server")));

        WScript.echo("Listing printers\n");

        for (; !Enum.atEnd(); Enum.moveNext())
        {
            oPrinter = Enum.item();

            WScript.echo(oPrinter.PrinterName);
        }

        WScript.echo("Success listing printers");
    }
    catch(Err)
    {
       WScript.echo("Error listing printers " + (0xFFFF & Err.number).toString(16) + ". " + Err.description);
    }
}

//
// Debug display helper function
//
function DebugPrint(Flags, Str)
{
    if (gDebugFlag)
    {
        if (Flags == kDebugTrace)
        {
            WScript.echo(Str);
        }
    }
}
        
//
// Parse the command line into it's components
//
function ParseCommandLine(ParamDict)
{
    DebugPrint(kDebugTrace, "In the ParseCommandLine");

    var oArgs;
    var strArg; 
    var i, iAction;

    oArgs = WScript.Arguments;

    iAction = kActionUnknown;

    for (i = 0; i < oArgs.length; i++)
    {
        switch(oArgs(i))
        {
        case "-a":
                iAction = kActionAdd;
                break;
                
        case "-g":
                iAction = kActionGet;
                break;
                
        case "-l":
                iAction = kActionList; 
                break;
            
        case "-i":
                ParamDict.Add("IPAddress", oArgs(++i));
                break;
                
        case "-b":
                ParamDict.Add("Printer", oArgs(++i));
                break;

        case "-p":
                ParamDict.Add("Port", oArgs(++i));
                break;
                
        case "-c":
                ParamDict.Add("Server", oArgs(++i));
                break;
                
        case "-d":
                ParamDict.Add("Driver", oArgs(++i));    
                break;
                
        case "-?":
                Usage(true);
                return;

        default:
                Usage(true);
                return;
        }       
    }
                     
    return iAction;
}

//
// Display command usage.
//
function Usage(bExit)
{
    WScript.echo("PrnAdmin demo JavaScript");
    WScript.echo("Usage: prndemo.js [-agl?][-b printer][-c server][-i ip-adrress]");
    WScript.echo("                         [-d driver][-p port]");
    WScript.echo("Arguments:");
    WScript.echo("-a     - adds a printer with the specified driver");
    WScript.echo("-l     - list printers");
    WScript.echo("-g     - for an IP address, gets the preferred device settings");
    WScript.echo("-c     - server name");
    WScript.echo("-d     - driver name");
    WScript.echo("-p     - port name");
    WScript.echo("-i     - ip address");
    WScript.echo("");
    WScript.echo("Examples:");
    WScript.echo("prndemo.js -g -i 1.2.3.4");
    WScript.echo("prndemo.js -a -b Printer -d \"Driver\" -p lpt1:");
    WScript.echo("prndemo.js -a -b Printer -d \"Driver\" -i 1.2.3.4");
    WScript.echo("prndemo.js -l -c \\\\server");

    WScript.echo("\nThe port for the printer can be specified using the -p or");
    WScript.echo("the -i the option. The script will first check the port name"); 
    WScript.echo("If it is present, the printer will get that port. "); 
    WScript.echo("If no port is specified, then if an ip address is present,");
    WScript.echo("the script will get the prefered settings of the device and"); 
    WScript.echo("add a tcp port, then the printer using that port.");
    WScript.echo("The script handles the case when the port already exists.");
    WScript.echo("If the device is not responding, a default lpr tcp port will be created.");

    if (bExit)
    {
        WScript.quit(1);
    }
}

//
// Determines which program is used to run this script. 
// Returns true if the script host is cscript.exe
//
function IsHostCscript()
{
    var strFullName; 
    var strString; 
    var strRight;
    var iLen; 
    var bReturn = false;
    
    try 
    {   
        strFullName = WScript.FullName;
       
        strString = "cscript";
   
        iLen = strString.length;
   
        strRight  = strFullName.substr(strFullName.length - iLen, iLen);
   
        if (strString == strRight.toLowerCase())
        { 
           bReturn = true;
        }
        else 
        {
            strString = "cscript.exe";
   
            iLen = strString.length;
   
            strRight  = strFullName.substr(strFullName.length - iLen, iLen);
       
            if (strString == strRight.toLowerCase())
            {
               bReturn = true;
            }
        }
    }
    catch(Err)
    {
       WScript.echo("Error 0x " + (0xFFFF & Err.number).toString(16) + " occurred. " + 
                    Err.description + ".\nThe scripting host could not be determined");
    }
    
    return bReturn;
}

